/* 
 *  EndRequest.java
 * 
 *  Copyright 2016 Avaya Inc. All Rights Reserved.
 * 
 *  Usage of this source is bound to the terms described
 *  in AvayaLicenseSDK.rtf.
 * 
 *  Avaya - Confidential & Proprietary. Use pursuant to your signed agreement
 *  or Avaya Policy
 * 
 */
package com.avaya.ccs.javafxrefclient.request;

import com.avaya.ccs.core.CommandArgs;
import com.avaya.ccs.javafxrefclient.Logger;

import java.util.Map;

public class ReviewEmailRequest extends InteractionRequest {

	private static final Logger LOG = Logger.getLogger(ReviewEmailRequest.class);
    private final String reviewType;
    private final Map<CommandArgs.Argument, String> queryParams;
    private final String data;
    public ReviewEmailRequest(String interactionID, String reviewType, Map<CommandArgs.Argument,
            String> queryParams, String data) {
        super(LOG, interactionID);
        this.reviewType = reviewType;
        this.queryParams = queryParams;
        this.data = data;
    }

	/**
     * The call method executes on the outgoingRequest thread
     *
     * @return
     * @throws Exception
     */
    @Override
    protected Object call() throws Exception {
        String methodName = "call() ";
        LOG.trace(methodName + "+");
        getInteraction().requestReviewEmail(reviewType, queryParams,data);
        LOG.trace(methodName + "-");
        return null;
    }
}
